package music;

public class GuitarPlayer extends Musician {
	
	private String favoriteGuitar;

    public GuitarPlayer(String name, String instrument, String favoriteGuitar) {
        super(name, instrument);
        this.favoriteGuitar = favoriteGuitar;
    }

    public GuitarPlayer() {
        super();
    }
    
    public void prettyPrint() {
//      System.out.println("Musician: ");
//      System.out.println('\t' + this.name);
//      System.out.println('\t' + this.instrument);
        super.prettyPrint();
        System.out.println('\t' + this.favoriteGuitar);
    }
    
    @Override
    public String toString() {
        // TODO Auto-generated method stub
//      return super.toString();
//      return super.name + super.instrument;
        return super.toString() + " (favorite guitar: " + this.favoriteGuitar + ")";
    }

    public String getFavoriteGuitar() {
        return favoriteGuitar;
    }

    public void setFavoriteGuitar(String favoriteGuitar) {
        this.favoriteGuitar = favoriteGuitar;
    }

}
